(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 10.4' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     18698,        391]
NotebookOptionsPosition[     18180,        373]
NotebookOutlinePosition[     18611,        390]
CellTagsIndexPosition[     18568,        387]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Column", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Row", "[", 
        RowBox[{"{", 
         RowBox[{"\"\<Distancia total: \>\"", ",", 
          RowBox[{
           RowBox[{"FindShortestTour", "[", 
            RowBox[{"GeoPosition", "/@", 
             RowBox[{"Select", "[", 
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"CityData", "[", 
                  RowBox[{"#", ",", "\"\<Coordinates\>\""}], "]"}], "&"}], "/@",
                 " ", 
                RowBox[{
                "GExtraerRegionesGeograficas", "[", "GPaises", "]"}]}], ",", 
               "VectorQ"}], "]"}]}], "]"}], "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], "}"}], "]"}], ",", 
       RowBox[{"GeoGraphics", "[", 
        RowBox[{"{", 
         RowBox[{"Thick", ",", " ", "Red", ",", 
          RowBox[{"GeoPath", "[", 
           RowBox[{"GeoPosition", "/@", 
            RowBox[{
             RowBox[{"Select", "[", 
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"CityData", "[", 
                  RowBox[{"#", ",", "\"\<Coordinates\>\""}], "]"}], "&"}], "/@",
                 " ", 
                RowBox[{
                "GExtraerRegionesGeograficas", "[", "GPaises", "]"}]}], ",", 
               "VectorQ"}], "]"}], "[", 
             RowBox[{"[", 
              RowBox[{"Last", "[", 
               RowBox[{"FindShortestTour", "[", 
                RowBox[{"GeoPosition", "/@", 
                 RowBox[{"Select", "[", 
                  RowBox[{
                   RowBox[{
                    RowBox[{
                    RowBox[{"CityData", "[", 
                    RowBox[{"#", ",", "\"\<Coordinates\>\""}], "]"}], "&"}], "/@",
                     " ", 
                    RowBox[{
                    "GExtraerRegionesGeograficas", "[", "GPaises", "]"}]}], 
                   ",", "VectorQ"}], "]"}]}], "]"}], "]"}], "]"}], "]"}]}], 
           "]"}]}], "}"}], "]"}]}], "}"}], ",", "Center"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "GPaises", ",", "\"\<CostaRica\>\"", ",", "\"\<Pa\[IAcute]s:\>\""}], 
      "}"}], ",", 
     RowBox[{"GListaPaises", "[", "]"}], ",", 
     RowBox[{"ControlType", "\[Rule]", "PopupMenu"}]}], "}"}], ",", 
   RowBox[{"Initialization", "\[RuleDelayed]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"GList20", "=", 
       RowBox[{"CountryData", "[", "]"}]}], ";", 
      RowBox[{
       RowBox[{"GListaPaises", "[", "]"}], ":=", 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"GList21", "=", 
           RowBox[{"{", "}"}]}], "}"}], ",", 
         RowBox[{
          RowBox[{"For", "[", 
           RowBox[{
            RowBox[{"Gi31", "=", "1"}], ",", 
            RowBox[{"Gi31", "\[LessEqual]", 
             RowBox[{"Length", "[", "GList20", "]"}]}], ",", 
            RowBox[{
             RowBox[{"GList21", "=", 
              RowBox[{"Append", "[", 
               RowBox[{"GList21", ",", 
                RowBox[{"ToString", "[", 
                 RowBox[{"GList20", "[", 
                  RowBox[{"[", 
                   RowBox[{"Gi31", ",", "2"}], "]"}], "]"}], "]"}]}], "]"}]}],
              ";", 
             RowBox[{"Gi31", "++"}]}]}], "]"}], ";", "GList21"}]}], "]"}]}], 
      ";", 
      RowBox[{
       RowBox[{"GExtraerRegionesGeograficas", "[", "GCountry_", "]"}], ":=", 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"GVl71", "=", 
            RowBox[{"EntityList", "[", "\"\<City\>\"", "]"}]}], ",", 
           "GList22"}], "}"}], ",", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"StringQ", "[", "GCountry", "]"}], ",", 
           RowBox[{"GList22", "=", 
            RowBox[{"Select", "[", 
             RowBox[{"GVl71", ",", 
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"#", "[", 
                  RowBox[{"[", "2", "]"}], "]"}], "[", 
                 RowBox[{"[", "3", "]"}], "]"}], "\[Equal]", 
                RowBox[{"StringJoin", "[", 
                 RowBox[{"StringSplit", "[", "GCountry", "]"}], "]"}]}], 
               "&"}]}], "]"}]}]}], "]"}]}], "]"}]}]}], ")"}]}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"None", ",", "None"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Column", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Spacer", "[", 
             RowBox[{"{", 
              RowBox[{"400", ",", "2"}], "}"}], "]"}], ",", 
            RowBox[{"Row", "[", 
             RowBox[{"{", 
              RowBox[{"Style", "[", 
               RowBox[{
               "\"\<Autor: Enrique V\[IAcute]lchez Quesada\>\"", ",", "Bold", 
                ",", "10", ",", 
                RowBox[{"RGBColor", "[", 
                 RowBox[{"0", ",", "0.333333", ",", "0"}], "]"}]}], "]"}], 
              "}"}], "]"}], ",", 
            RowBox[{"Row", "[", 
             RowBox[{"{", 
              RowBox[{"Style", "[", 
               RowBox[{
               "\"\<Escuela de Inform\[AAcute]tica | Universidad Nacional de \
Costa Rica\>\"", ",", "Bold", ",", "10", ",", 
                RowBox[{"RGBColor", "[", 
                 RowBox[{"0.12", ",", "0", ",", "0.5"}], "]"}]}], "]"}], 
              "}"}], "]"}]}], "}"}], ",", "Center"}], "]"}], ",", 
        RowBox[{"Style", "[", 
         RowBox[{"\"\<Circuitos de Hamilton\>\"", ",", " ", "Bold", ",", " ", 
          RowBox[{"RGBColor", "[", 
           RowBox[{"0", ",", "0.333333", ",", "0"}], "]"}]}], "]"}]}], 
       "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.672692903609235*^9, 3.672692904478568*^9}, {
  3.8011554306439233`*^9, 3.8011554355860586`*^9}, {3.801155476143383*^9, 
  3.801155498941313*^9}},
 CellLabel->"In[4]:=",ExpressionUUID->"345d3c50-9efc-4784-a6eb-e64f413bfc19"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`GPaises$$ = "CostaRica", Typeset`show$$ = 
    True, Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"sin t\[IAcute]tulo\"", Typeset`specs$$ = {{{
       Hold[$CellContext`GPaises$$], "CostaRica", "Pa\[IAcute]s:"}, {
      "Afghanistan", "AlandIslands", "Albania", "Algeria", "AmericanSamoa", 
       "Andorra", "Angola", "Anguilla", "AntiguaBarbuda", "Argentina", 
       "Armenia", "Aruba", "Australia", "Austria", "Azerbaijan", "Bahamas", 
       "Bahrain", "Bangladesh", "Barbados", "Belarus", "Belgium", "Belize", 
       "Benin", "Bermuda", "Bhutan", "Bolivia", "BonaireSintEustatiusAndSaba",
        "BosniaHerzegovina", "Botswana", "BouvetIsland", "Brazil", 
       "BritishIndianOceanTerritory", "BritishVirginIslands", "Brunei", 
       "Bulgaria", "BurkinaFaso", "Burundi", "Cambodia", "Cameroon", "Canada",
        "CapeVerde", "CaymanIslands", "CentralAfricanRepublic", "Chad", 
       "Chile", "China", "ChristmasIsland", "CocosKeelingIslands", "Colombia",
        "Comoros", "CookIslands", "CostaRica", "Croatia", "Cuba", "Curacao", 
       "Cyprus", "CzechRepublic", "DemocraticRepublicCongo", "Denmark", 
       "Djibouti", "Dominica", "DominicanRepublic", "EastTimor", "Ecuador", 
       "Egypt", "ElSalvador", "EquatorialGuinea", "Eritrea", "Estonia", 
       "Ethiopia", "FalklandIslands", "FaroeIslands", "Fiji", "Finland", 
       "France", "FrenchGuiana", "FrenchPolynesia", 
       "FrenchSouthernAndAntarcticLands", "Gabon", "Gambia", "GazaStrip", 
       "Georgia", "Germany", "Ghana", "Gibraltar", "Greece", "Greenland", 
       "Grenada", "Guadeloupe", "Guam", "Guatemala", "Guernsey", "Guinea", 
       "GuineaBissau", "Guyana", "Haiti", "Honduras", "HongKong", "Hungary", 
       "Iceland", "India", "Indonesia", "Iran", "Iraq", "Ireland", 
       "IsleOfMan", "Israel", "Italy", "IvoryCoast", "Jamaica", "Japan", 
       "Jersey", "Jordan", "Kazakhstan", "Kenya", "Kiribati", "Kosovo", 
       "Kuwait", "Kyrgyzstan", "Laos", "Latvia", "Lebanon", "Lesotho", 
       "Liberia", "Libya", "Liechtenstein", "Lithuania", "Luxembourg", 
       "Macau", "Macedonia", "Madagascar", "Malawi", "Malaysia", "Maldives", 
       "Mali", "Malta", "MarshallIslands", "Martinique", "Mauritania", 
       "Mauritius", "Mayotte", "Mexico", "Micronesia", "Moldova", "Monaco", 
       "Mongolia", "Montenegro", "Montserrat", "Morocco", "Mozambique", 
       "Myanmar", "Namibia", "Nauru", "Nepal", "Netherlands", "NewCaledonia", 
       "NewZealand", "Nicaragua", "Niger", "Nigeria", "Niue", "NorfolkIsland",
        "NorthernMarianaIslands", "NorthKorea", "Norway", "Oman", "Pakistan", 
       "Palau", "Panama", "PapuaNewGuinea", "Paraguay", "Peru", "Philippines",
        "PitcairnIslands", "Poland", "Portugal", "PuertoRico", "Qatar", 
       "RepublicCongo", "Reunion", "Romania", "Russia", "Rwanda", 
       "SaintBarthelemy", "SaintHelena", "SaintKittsNevis", "SaintLucia", 
       "SaintMartin", "SaintPierreMiquelon", "SaintVincentGrenadines", 
       "Samoa", "SanMarino", "SaoTomePrincipe", "SaudiArabia", "Senegal", 
       "Serbia", "Seychelles", "SierraLeone", "Singapore", "SintMaarten", 
       "Slovakia", "Slovenia", "SolomonIslands", "Somalia", "SouthAfrica", 
       "SouthGeorgiaAndTheSouthSandwichIslands", "SouthKorea", "SouthSudan", 
       "Spain", "SriLanka", "Sudan", "Suriname", "Svalbard", "Swaziland", 
       "Sweden", "Switzerland", "Syria", "Taiwan", "Tajikistan", "Tanzania", 
       "Thailand", "Togo", "Tokelau", "Tonga", "TrinidadTobago", "Tunisia", 
       "Turkey", "Turkmenistan", "TurksCaicosIslands", "Tuvalu", "Uganda", 
       "Ukraine", "UnitedArabEmirates", "UnitedKingdom", "UnitedStates", 
       "UnitedStatesMinorOutlyingIslands", "UnitedStatesVirginIslands", 
       "Uruguay", "Uzbekistan", "Vanuatu", "VaticanCity", "Venezuela", 
       "Vietnam", "WallisFutuna", "WestBank", "WesternSahara", "Yemen", 
       "Zambia", "Zimbabwe"}}}, Typeset`size$$ = {299., {122., 131.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = False}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`GPaises$$ = "CostaRica"}, 
      "ControllerVariables" :> {}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Column[{
         Row[{"Distancia total: ", 
           Part[
            FindShortestTour[
             Map[GeoPosition, 
              Select[
               Map[CityData[#, "Coordinates"]& , 
                $CellContext`GExtraerRegionesGeograficas[$CellContext`GPaises$\
$]], VectorQ]]], 1]}], 
         GeoGraphics[{Thick, Red, 
           GeoPath[
            Map[GeoPosition, 
             Part[
              Select[
               Map[CityData[#, "Coordinates"]& , 
                $CellContext`GExtraerRegionesGeograficas[$CellContext`GPaises$\
$]], VectorQ], 
              Last[
               FindShortestTour[
                Map[GeoPosition, 
                 Select[
                  Map[CityData[#, "Coordinates"]& , 
                   $CellContext`GExtraerRegionesGeograficas[$CellContext`\
GPaises$$]], VectorQ]]]]]]]}]}, Center], 
      "Specifications" :> {{{$CellContext`GPaises$$, "CostaRica", 
          "Pa\[IAcute]s:"}, {
         "Afghanistan", "AlandIslands", "Albania", "Algeria", "AmericanSamoa",
           "Andorra", "Angola", "Anguilla", "AntiguaBarbuda", "Argentina", 
          "Armenia", "Aruba", "Australia", "Austria", "Azerbaijan", "Bahamas",
           "Bahrain", "Bangladesh", "Barbados", "Belarus", "Belgium", 
          "Belize", "Benin", "Bermuda", "Bhutan", "Bolivia", 
          "BonaireSintEustatiusAndSaba", "BosniaHerzegovina", "Botswana", 
          "BouvetIsland", "Brazil", "BritishIndianOceanTerritory", 
          "BritishVirginIslands", "Brunei", "Bulgaria", "BurkinaFaso", 
          "Burundi", "Cambodia", "Cameroon", "Canada", "CapeVerde", 
          "CaymanIslands", "CentralAfricanRepublic", "Chad", "Chile", "China",
           "ChristmasIsland", "CocosKeelingIslands", "Colombia", "Comoros", 
          "CookIslands", "CostaRica", "Croatia", "Cuba", "Curacao", "Cyprus", 
          "CzechRepublic", "DemocraticRepublicCongo", "Denmark", "Djibouti", 
          "Dominica", "DominicanRepublic", "EastTimor", "Ecuador", "Egypt", 
          "ElSalvador", "EquatorialGuinea", "Eritrea", "Estonia", "Ethiopia", 
          "FalklandIslands", "FaroeIslands", "Fiji", "Finland", "France", 
          "FrenchGuiana", "FrenchPolynesia", 
          "FrenchSouthernAndAntarcticLands", "Gabon", "Gambia", "GazaStrip", 
          "Georgia", "Germany", "Ghana", "Gibraltar", "Greece", "Greenland", 
          "Grenada", "Guadeloupe", "Guam", "Guatemala", "Guernsey", "Guinea", 
          "GuineaBissau", "Guyana", "Haiti", "Honduras", "HongKong", 
          "Hungary", "Iceland", "India", "Indonesia", "Iran", "Iraq", 
          "Ireland", "IsleOfMan", "Israel", "Italy", "IvoryCoast", "Jamaica", 
          "Japan", "Jersey", "Jordan", "Kazakhstan", "Kenya", "Kiribati", 
          "Kosovo", "Kuwait", "Kyrgyzstan", "Laos", "Latvia", "Lebanon", 
          "Lesotho", "Liberia", "Libya", "Liechtenstein", "Lithuania", 
          "Luxembourg", "Macau", "Macedonia", "Madagascar", "Malawi", 
          "Malaysia", "Maldives", "Mali", "Malta", "MarshallIslands", 
          "Martinique", "Mauritania", "Mauritius", "Mayotte", "Mexico", 
          "Micronesia", "Moldova", "Monaco", "Mongolia", "Montenegro", 
          "Montserrat", "Morocco", "Mozambique", "Myanmar", "Namibia", 
          "Nauru", "Nepal", "Netherlands", "NewCaledonia", "NewZealand", 
          "Nicaragua", "Niger", "Nigeria", "Niue", "NorfolkIsland", 
          "NorthernMarianaIslands", "NorthKorea", "Norway", "Oman", 
          "Pakistan", "Palau", "Panama", "PapuaNewGuinea", "Paraguay", "Peru",
           "Philippines", "PitcairnIslands", "Poland", "Portugal", 
          "PuertoRico", "Qatar", "RepublicCongo", "Reunion", "Romania", 
          "Russia", "Rwanda", "SaintBarthelemy", "SaintHelena", 
          "SaintKittsNevis", "SaintLucia", "SaintMartin", 
          "SaintPierreMiquelon", "SaintVincentGrenadines", "Samoa", 
          "SanMarino", "SaoTomePrincipe", "SaudiArabia", "Senegal", "Serbia", 
          "Seychelles", "SierraLeone", "Singapore", "SintMaarten", "Slovakia",
           "Slovenia", "SolomonIslands", "Somalia", "SouthAfrica", 
          "SouthGeorgiaAndTheSouthSandwichIslands", "SouthKorea", 
          "SouthSudan", "Spain", "SriLanka", "Sudan", "Suriname", "Svalbard", 
          "Swaziland", "Sweden", "Switzerland", "Syria", "Taiwan", 
          "Tajikistan", "Tanzania", "Thailand", "Togo", "Tokelau", "Tonga", 
          "TrinidadTobago", "Tunisia", "Turkey", "Turkmenistan", 
          "TurksCaicosIslands", "Tuvalu", "Uganda", "Ukraine", 
          "UnitedArabEmirates", "UnitedKingdom", "UnitedStates", 
          "UnitedStatesMinorOutlyingIslands", "UnitedStatesVirginIslands", 
          "Uruguay", "Uzbekistan", "Vanuatu", "VaticanCity", "Venezuela", 
          "Vietnam", "WallisFutuna", "WestBank", "WesternSahara", "Yemen", 
          "Zambia", "Zimbabwe"}, ControlType -> PopupMenu}}, 
      "Options" :> {FrameLabel -> {{None, None}, {
           Column[{
             Spacer[{400, 2}], 
             Row[{
               Style["Autor: Enrique V\[IAcute]lchez Quesada", Bold, 10, 
                RGBColor[0, 0.333333, 0]]}], 
             Row[{
               Style[
               "Escuela de Inform\[AAcute]tica | Universidad Nacional de \
Costa Rica", Bold, 10, 
                RGBColor[0.12, 0, 0.5]]}]}, Center], 
           Style["Circuitos de Hamilton", Bold, 
            RGBColor[0, 0.333333, 0]]}}}, "DefaultOptions" :> {}],
     ImageSizeCache->{624., {243., 252.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    Initialization:>(($CellContext`GList20 = 
       CountryData[]; $CellContext`GListaPaises[] := 
       Module[{$CellContext`GList21 = {}}, 
         For[$CellContext`Gi31 = 1, $CellContext`Gi31 <= 
           Length[$CellContext`GList20], $CellContext`GList21 = 
            Append[$CellContext`GList21, 
              ToString[
               Part[$CellContext`GList20, $CellContext`Gi31, 2]]]; 
           Increment[$CellContext`Gi31]]; $CellContext`GList21]; \
$CellContext`GExtraerRegionesGeograficas[
         Pattern[$CellContext`GCountry, 
          Blank[]]] := 
       Module[{$CellContext`GVl71 = EntityList["City"], $CellContext`GList22}, 
         If[
          StringQ[$CellContext`GCountry], $CellContext`GList22 = 
          Select[$CellContext`GVl71, Part[
              Part[#, 2], 3] == StringJoin[
              StringSplit[$CellContext`GCountry]]& ]]]); 
     Typeset`initDone$$ = True),
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{3.8011559062877226`*^9},
 CellLabel->"Out[4]=",ExpressionUUID->"e4bdc32f-9b3d-4c17-92d4-afecd0424048"]
}, Open  ]]
},
WindowSize->{1366, 685},
WindowMargins->{{-8, Automatic}, {Automatic, -8}},
Magnification:>1.5 Inherited,
FrontEndVersion->"12.1 para Microsoft Windows (64-bit) (March 14, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"48276ad4-5502-4db7-bf99-3d737dee5114"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 6096, 156, 1478, "Input",ExpressionUUID->"345d3c50-9efc-4784-a6eb-e64f413bfc19"],
Cell[6679, 180, 11485, 190, 564, "Output",ExpressionUUID->"e4bdc32f-9b3d-4c17-92d4-afecd0424048"]
}, Open  ]]
}
]
*)

